/*{
	"GUID":"BB101941-A156-4332-B70F-22DD4B4236BD",
	"INPUTS":[
		{
			"TYPE":"image",
			"FILE":"waldenMap.png"
		},
		{
			"TYPE":"image",
			"FILE":"vignetteMap1.png"
		}
	],
	"PARAMS":[
		{
			"NAME":"strength",
			"TYPE":"float",
			"DEFAULT":1.0,
			"MIN":0.0,
			"MAX":1.0
		}
	]
}*/

#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE |CLK_ADDRESS_CLAMP_TO_EDGE  | CLK_FILTER_LINEAR;

static vec4 INPUT(image2d_t src_data, vec2 tc, __global FilterParam* param)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

static vec4 INPUTTEXT(image2d_t src_data, vec2 tc, __global FilterParam* param)
{
	return read_imagef(src_data, sampler, tc);
}


__kernel void MAIN(
	__read_only image2d_t input1, 
	__read_only image2d_t input2,
	__read_only image2d_t input3, 
	__write_only image2d_t dest_data,
	__global FilterParam* param,
	int alpha)
{
	float iGlobalTime = param->cur_time / param->total_time;
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	
	int W = get_global_size(0);
	int H = get_global_size(1);
	float2 resolution = (float2)(W,H);
	float2 iResolution = resolution;
	int2 gl_FragCoord = (int2)(get_global_id0( param), get_global_id1( param));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	
	vec4 orig = INPUT(input1,tc, param);
	vec3 texel = orig.xyz;
     
    texel = (vec3)(
                  INPUTTEXT(input2, (vec2)(texel.z, .16666f), param).z,
                  INPUTTEXT(input2, (vec2)(texel.y, .5f), param).y,
                  INPUTTEXT(input2, (vec2)(texel.x, .83333f), param).x);
     vec3 output; 
     vec2 tt = (2.0f * tc) - 1.0f;
     float d = dot(tt, tt);
     vec2 lookup = (vec2)(d, texel.x);
     output.x = INPUTTEXT(input3, lookup, param).z;
     lookup.y = texel.y;
     output.y = INPUTTEXT(input3,lookup, param).y;
     lookup.y = texel.z;
     output.z	= INPUTTEXT(input3,lookup, param).x;
     
    write_imagef(dest_data, (int2)(get_global_id(0), get_global_id(1)), mix( (vec4)(output.zyx, orig.w), orig, (vec4)(1.0f - alpha/100.0f)) );

}